# RTP Video Stream Extractors for Wireshark

三个独立的 Wireshark Lua 插件，用于从 RTP 数据包中提取 H.264、H.265 和 VP8 视频流。

## 插件列表

### 1. rtp_h264_extractor.lua
从 RTP 包中提取 H.264/AVC 视频流，输出 `.264` 文件（Annex-B 格式）。

**功能特性：**
- 处理单个 NAL 单元包 (types 1-23)
- 处理 FU-A 分片包 (type 28)
- 处理 STAP-A 聚合包 (type 24)
- 自动重排序（jitter buffer）
- 两阶段扫描确保完整性

**菜单位置：** Tools → Extract h264 stream from RTP

### 2. rtp_h265_extractor.lua
从 RTP 包中提取 H.265/HEVC 视频流，输出 `.265` 文件（Annex-B 格式）。

**功能特性：**
- 处理单个 NAL 单元包 (types 0-47)
- 处理 FU (Fragmentation Unit) 分片包 (type 49)，符合 RFC 7798
- 处理 AP (Aggregation Packet) 聚合包 (type 48)
- H.265 双字节 NAL 头正确处理
- 自动重排序（jitter buffer）
- 两阶段扫描确保完整性

**菜单位置：** Tools → Extract H.265 stream from RTP

### 3. rtp_vp8_extractor.lua
从 RTP 包中提取 VP8 视频流，输出 IVF 容器格式 `.ivf` 文件。

**功能特性：**
- 处理 VP8 RTP payload 描述符（符合 RFC 7741）
- 支持扩展控制位（PictureID, TL0PICIDX 等）
- 自动检测帧边界（S bit）
- 输出标准 IVF 文件头
- 自动重排序（jitter buffer）
- 两阶段扫描确保完整性

**菜单位置：** Tools → Extract VP8 stream from RTP

## 安装方法

### Windows
1. 找到 Wireshark 个人插件目录：
   - `%APPDATA%\Wireshark\plugins\`
   - 或在 Wireshark 中：Help → About Wireshark → Folders → Personal Lua Plugins

2. 将三个 `.lua` 文件复制到该目录

3. 重启 Wireshark

### Linux/macOS
1. 找到插件目录：
   - `~/.local/lib/wireshark/plugins/` (Linux)
   - `~/.wireshark/plugins/` (旧版本)
   - 或在 Wireshark 中查看：Help → About Wireshark → Folders

2. 将 `.lua` 文件复制到该目录

3. 重启 Wireshark

## 使用方法

1. 在 Wireshark 中打开包含 RTP 视频流的 pcap/pcapng 文件

2. 确保包被正确识别为对应的视频协议：
   - H.264: Protocol 列应显示 "H.264"
   - H.265: Protocol 列应显示 "H.265" 或 "HEVC"
   - VP8: Protocol 列应显示 "VP8"

3. 如果未自动识别，可以手动设置：
   - 右键点击 RTP 包 → Decode As...
   - 选择对应的 payload type 并设置为 H264/H265/VP8

4. 点击菜单：
   - Tools → Extract h264 stream from RTP (H.264)
   - Tools → Extract H.265 stream from RTP (H.265)
   - Tools → Extract VP8 stream from RTP (VP8)

5. 查看弹出的文本窗口，显示提取进度和结果

6. 输出文件位置：
   - 默认：Wireshark 首选项中设置的文件打开目录 (`gui.fileopen.dir`)
   - 文件名格式：`video_YYYYMMDD-HHMMSS.{264|265|ivf}`
   - 如果首选项未设置，输出到当前目录 `dump.{264|265|ivf}`

## 输出格式说明

### H.264 / H.265 输出 (.264 / .265)
- **格式：** Annex-B 字节流格式
- **起始码：** 每个 NAL 单元前添加 `00 00 00 01` 起始码
- **播放：** 可用 ffplay、VLC、MediaInfo 等工具直接播放/分析
  ```bash
  ffplay video_20231121-143000.264
  ffplay video_20231121-143000.265
  ```

### VP8 输出 (.ivf)
- **格式：** IVF (Indeo Video Format) 容器
- **包含：** IVF 文件头（32字节）+ 逐帧数据（每帧有 12 字节帧头）
- **参数：** 默认 640x360, 30fps（可根据实际调整源码）
- **播放：** 可用 ffplay、VLC 等播放
  ```bash
  ffplay video_20231121-143000.ivf
  ```

## 技术细节

### Jitter Buffer
所有插件使用 jitter buffer（大小：50 包）对乱序的 RTP 包进行重排序，确保：
- 按序号正确组装分片（FU）
- 避免序号跳跃导致的不完整帧

### 两阶段处理
1. **Phase 1（计数）：** 遍历所有包，统计总包数
2. **Phase 2（提取）：** 重新遍历并提取视频数据，确保完整性

### H.265 特殊处理
- NAL 单元头为 2 字节（与 H.264 的 1 字节不同）
- FU 包重构时需正确组合 NAL 头的 F bit、LayerId、TID 和分片类型

### VP8 RTP Payload
- 正确解析 VP8 RTP payload descriptor（1-4 字节可变长度）
- 支持扩展控制位（PictureID 可为 7 位或 15 位）
- 基于 S bit 判断帧边界

## 故障排除

### 问题：菜单中看不到提取选项
- 检查插件是否正确安装到插件目录
- 重启 Wireshark
- 查看 Help → About Wireshark → Plugins 标签页，确认 Lua 插件已加载

### 问题：提示 "gui.fileopen.dir is not set"
- 打开任意 pcap 文件（File → Open）
- 或在 Edit → Preferences → Appearance → Layout → Open Files In 中设置目录
- 或修改插件代码中的 `filename` 为固定路径

### 问题：无法识别视频协议
- 确保 Wireshark 版本支持对应的视频解码器（H.264/H.265/VP8）
- 手动设置 Decode As（右键 UDP 包 → Decode As → RTP → 选择对应 payload type）
- 检查 RTP payload type 是否正确配置（通常动态范围 96-127）

### 问题：提取的文件无法播放
- 检查文本窗口日志，查看是否有 "Incomplete" 错误
- 确认抓包完整（没有丢包）
- H.264/H.265：确保包含 SPS/PPS 参数集
- VP8：使用支持 IVF 的播放器（ffplay、VLC 3.0+）

## 参考标准
- **H.264 RTP:** RFC 6184
- **H.265 RTP:** RFC 7798  
- **VP8 RTP:** RFC 7741
- **IVF Format:** [VP8/VP9 Bitstream & Decoding Guide](https://chromium.googlesource.com/webm/libvpx/)

## 许可协议
基于原始 rtp_h264_extractor.lua (Copyright 2015 Volvet Zhang) 修改和扩展。

采用 GNU Lesser General Public License v2.1 或更高版本发布。

## 作者
- H.264 原始版本: Volvet Zhang <volvet2002@gmail.com>
- H.265 & VP8 适配: 基于 H.264 版本改编

---

如有问题或改进建议，请查看 Wireshark 的 Lua API 文档或提交反馈。
